package w83b.w83bDAO;


import java.sql.CallableStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bDatosFasesTramitesBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bDocBeanImpug;
import w83b.w83bBeans.W83bHistorialImpugnacionBean;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bBeans.W83bTipoDocumentoBean;
import w83b.w83bBeans.W83bTramiteImpugnacionBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMigracionBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosImpugnacionBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTiposDocumentosVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTramitesBD;
import w83b.w83bManager.W83bComunes;
import w83b.w83bManager.W83bIComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bImpugnacionesDAO.
 * @author a
 */
public class W83bImpugnacionesDAO implements W83bIImpugnacionesDAO {
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public java.util.List buscarImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesVistaBD.VERSION).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NIMPUGNACION).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NPREAVISO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NACTA).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fimpugnacionDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FIMPUGNACION).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.ARBITRO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fenvioarbitroDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FENVIOARBITRO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fdesestimientoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FDESESTIMIENTO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NLAUDO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.flaudoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FLAUDO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESCRESULTADO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESERESULTADO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DNIIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.ABRSINDICATOS).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoPreaviso).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numPreaviso).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoActa).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numActa).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoLaudo).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numLaudo).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.CITACION).append(", ");
		strSql.append(" UPPER("+W83bImpugnacionesVistaBD.RAZONSOCIAL+") AS ").append(W83bImpugnacionesVistaBD.RAZONSOCIAL);
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" FROM ").append(W83bImpugnacionesVistaBD.impugnacionesSimpleView).append(" , ").append(W83bCentroTrabajoVistaBD.nombreVistaCompletoOpt);
		
		strSql.append(" WHERE ").append(" ").append(W83bImpugnacionesVistaBD.numImpugnacion).append(" > 0");
		strSql.append(" AND ").append(" ").append(W83bImpugnacionesVistaBD.IDCENTRO).append("= ").append(W83bCentroTrabajoVistaBD.codcentro);
		strSql.append("(+) ");
		
		
		List restoSql=((List)this.getBusquedaSql(param,params));
		strSql.append((StringBuffer)restoSql.get(0));
		params=(List)restoSql.get(1);
	
		
	
		String[] ordenacion=param.getIdColumna().split(",");
		if(ordenacion.length>0){
			if(StringUtils.isNotEmpty(ordenacion[0])){
				strSql.append(" ORDER BY ");
			}
		}
		for(int i=0;i<ordenacion.length;i++){
			if(i!=0){
				strSql.append(", ");
			}
				strSql.append(ordenacion[i]).append(" ").append(param.getSort());	
		}
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bImpugnacionBean.class,param.getUsuarioBean(), null);
		
		return listaActas;	
	}
	private List getBusquedaSql(w83b.w83bBeans.W83bImpugnacionBean param, List parametros)
	{
		List resul=new ArrayList();
		List params=parametros;
		StringBuffer strSql=new StringBuffer(W83bClsConstantes.CUARENTA);
		
		
		//NMERO DE Impugnacion
		if(StringUtils.isNotEmpty(param.getNumImpugnacionTerritorioDesde())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" >= ?");
			params.add(new Integer(param.getNumImpugnacionTerritorioDesde()));
		}		
		if(StringUtils.isNotEmpty(param.getNumImpugnacionTerritorioHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" <= ?");
			params.add(new Integer(param.getNumImpugnacionTerritorioHasta()));
		}
		
		String desde = param.getNumImpugnacionAnyoDesde();
		String hasta = param.getNumImpugnacionAnyoHasta();
		String numDesde = param.getNumImpugnacionNumeroDesde();
		String numHasta = param.getNumImpugnacionNumeroHasta();
		if(StringUtils.isEmpty(param.getNumImpugnacionAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getNumImpugnacionAnyoHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumImpugnacionNumeroDesde())){
			numDesde = "000000";
		}else if(6>param.getNumImpugnacionNumeroDesde().length()){
			for(int i = param.getNumImpugnacionNumeroDesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumImpugnacionNumeroHasta())){
			numHasta = "999999";
		}else if(6>param.getNumImpugnacionNumeroHasta().length()){
			for(int i = param.getNumImpugnacionNumeroHasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		
		strSql.append(" AND ");		
		strSql.append(W83bImpugnacionesBD.nimpugnacionesint).append(" >= ?");
		params.add(Long.valueOf(desde));
		strSql.append(" AND ");				
		strSql.append(W83bImpugnacionesBD.nimpugnacionesint).append(" <= ?");
		params.add(Long.valueOf(hasta));
		
		
		
		//NMERO DE ACTA
		if(StringUtils.isNotEmpty(param.getNumActaTerritorioDesde())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" >= ?");
			params.add(new Integer(param.getNumActaTerritorioDesde()));
		}		
		if(StringUtils.isNotEmpty(param.getNumActaTerritorioHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" <= ?");
			params.add(new Integer(param.getNumActaTerritorioHasta()));
		}
		 desde = param.getNumActaAnyoDesde();
		 hasta = param.getNumActaAnyoHasta();
		 numDesde = param.getNumActaNumeroDesde();
		 numHasta = param.getNumActaNumeroHasta();
		if(StringUtils.isEmpty(param.getNumActaAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getNumActaAnyoHasta())){
			hasta = "9999";
		}
		
		if(StringUtils.isEmpty(param.getNumActaNumeroDesde())){
			numDesde = "000000";
		}else if(6>param.getNumActaNumeroDesde().length()){
			for(int i = param.getNumActaNumeroDesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumActaNumeroHasta())){
			numHasta = "999999";
		}else if(6>param.getNumActaNumeroHasta().length()){
			for(int i = param.getNumActaNumeroHasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ");	
		if(("0000000000").equals(desde)
				&& ("9999999999").equals(hasta))
		{
		
			strSql.append(" (").append(W83bImpugnacionesBD.nactasint).append(" IS NULL OR (");
		}
			
		strSql.append(W83bImpugnacionesBD.nactasint).append(" >= ?");
		params.add(Long.valueOf(desde));
		strSql.append(" AND ");				
		strSql.append(W83bImpugnacionesBD.nactasint).append(" <= ?");
		params.add(Long.valueOf(hasta));
		if(("0000000000").equals(desde)
				&& ("9999999999").equals(hasta))
		{
			strSql.append(" ))");
		}
		//fin NMERO DE ACTA
		//NMERO DE PREAVISO
		if(StringUtils.isNotEmpty(param.getNumPreavisoTerritorioDesde())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" >= ?");
			params.add(new Integer(param.getNumPreavisoTerritorioDesde()));
		}		
		if(StringUtils.isNotEmpty(param.getNumPreavisoTerritorioHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" <= ?");
			params.add(new Integer(param.getNumPreavisoTerritorioHasta()));
		}
		
		 desde = param.getNumPreavisoAnyoDesde();
		 hasta = param.getNumPreavisoAnyoHasta();
		 numDesde = param.getNumPreavisoNumeroDesde();
		 numHasta = param.getNumPreavisoNumeroHasta();
		if(StringUtils.isEmpty(param.getNumPreavisoAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getNumPreavisoAnyoHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumPreavisoNumeroDesde())){
			numDesde = "000000";
		}else if(6>param.getNumPreavisoNumeroDesde().length()){
			for(int i = param.getNumPreavisoNumeroDesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumPreavisoNumeroHasta())){
			numHasta = "999999";
		}else if(6>param.getNumPreavisoNumeroHasta().length()){
			for(int i = param.getNumPreavisoNumeroHasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ");	
		if(("0000000000").equals(desde)
				&& ("9999999999").equals(hasta))
		{
	
			strSql.append(" (").append(W83bImpugnacionesBD.npreavisosint).append(" IS NULL OR (");
		}
			
		
		strSql.append(W83bImpugnacionesBD.npreavisosint).append(" >= ?");
		params.add(Long.valueOf(desde));
		strSql.append(" AND ");				
		strSql.append(W83bImpugnacionesBD.npreavisosint).append(" <= ?");
		params.add(Long.valueOf(hasta));
		if(("0000000000").equals(desde)
				&& ("9999999999").equals(hasta))
		{
			strSql.append(" ))");
		}
		
		//fin de preaviso
		
		//NMERO DE LAUDO
		if(StringUtils.isNotEmpty(param.getNumLaudoTerritorioDesde())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" >= ?");
			params.add(new Integer(param.getNumLaudoTerritorioDesde()));
		}		
		if(StringUtils.isNotEmpty(param.getNumLaudoTerritorioHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" <= ?");
			params.add(new Integer(param.getNumLaudoTerritorioHasta()));
		}
		
		 desde = param.getNumLaudoAnyoDesde();
		 hasta = param.getNumLaudoAnyoHasta();
		 numDesde = param.getNumLaudoNumeroDesde();
		 numHasta = param.getNumLaudoNumeroHasta();
		if(StringUtils.isEmpty(param.getNumLaudoAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getNumLaudoAnyoHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumLaudoNumeroDesde())){
			numDesde = "000";
		}else if(3>param.getNumLaudoNumeroDesde().length()){
			for(int i = param.getNumLaudoNumeroDesde().length(),size = 3;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumLaudoNumeroHasta())){
			numHasta = "999";
		}else if(3>param.getNumLaudoNumeroHasta().length()){
			for(int i = param.getNumLaudoNumeroHasta().length(),size = 3;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ");
		if(("0000000").equals(desde)
				&& ("9999999").equals(hasta))
		{

			strSql.append(" (").append(W83bImpugnacionesBD.nlaudosint).append(" IS NULL OR (");
		}
				
		strSql.append(W83bImpugnacionesBD.nlaudosint).append(" >= ?");
		params.add(Long.valueOf(desde));
		strSql.append(" AND ");				
		strSql.append(W83bImpugnacionesBD.nlaudosint).append(" <= ?");
		params.add(Long.valueOf(hasta));
		if(("0000000").equals(desde)
				&& ("9999999").equals(hasta))
		{
			strSql.append(" ))");
		}
		
		//fin de LAUDO

		//FECHA IMPUGNACION
		if(StringUtils.isNotEmpty(param.getFechaImpugnacionDel())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.fimpugnacionDate).append(" >= to_date(?,?)");
			params.add(param.getFechaImpugnacionDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaImpugnacionHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.fimpugnacionDate).append(" <= to_date(?,?)");
			params.add(param.getFechaImpugnacionHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA Impugnacion
		//FECHA sin fecha laudo
		
		if(StringUtils.isNotEmpty(param.getSinFechaLaudo())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.flaudoDate).append(" is null");
		}
		//fin sin fechaEnvioArbitro
		//FECHA laudo
		if(StringUtils.isNotEmpty(param.getFechaLaudoDel())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.flaudoDate).append(" >= to_date(?,?)");
			params.add(param.getFechaLaudoDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaLaudoHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.flaudoDate).append(" <= to_date(?,?)");
			params.add(param.getFechaLaudoHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA laudo
		//FECHA sin envioArbitro
		
		if(StringUtils.isNotEmpty(param.getSinFechaEnvioArbitro())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.fenvioarbitroDate).append(" is null");
		}
		//fin sin fechaEnvioArbitro
		//FECHA envioArbitro
		if(StringUtils.isNotEmpty(param.getFechaEnvioArbitroDel())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.fenvioarbitroDate).append(" >= to_date(?,?)");
			params.add(param.getFechaEnvioArbitroDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaEnvioArbitroHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.fenvioarbitroDate).append(" <= to_date(?,?)");
			params.add(param.getFechaEnvioArbitroHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA envioArbitro
		
		//FECHA desestimiento
		if(StringUtils.isNotEmpty(param.getFechaDesestimientoDel())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.fdesestimientoDate).append(" >= to_date(?,?)");
			params.add(param.getFechaDesestimientoDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaDesestimientoHasta())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.fdesestimientoDate).append(" <= to_date(?,?)");
			params.add(param.getFechaDesestimientoHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA desestimiento
		
		//CENTRO DE TRABAJO
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCifnif())){
			strSql.append(" AND ").append(W83bCentroTrabajoVistaBD.cifnif).append(" = ?");
			params.add(param.getCentroTrabajo().getCifnif().toUpperCase());
		}
		
		
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
			strSql.append(" AND ").append(W83bCentroTrabajoVistaBD.nCentro).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getNumCentro()));
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getRazonSocial())){
			strSql.append(" AND (").append(W83bCentroTrabajoVistaBD.razonsocial).append(" LIKE ?");
			params.add("%"+param.getCentroTrabajo().getRazonSocial().toUpperCase()+"%");
			strSql.append(" or UPPER(").append(W83bCentroTrabajoVistaBD.razonsocialscaracteres).append(") like ?)");
			params.add("%"+param.getCentroTrabajo().getRazonSocial().toUpperCase()+"%");
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodMunicipio())){
			strSql.append(" AND ").append(W83bCentroTrabajoVistaBD.codMunicipio).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getCodMunicipio()));
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodTerritorio())){
			strSql.append(" AND ").append(W83bCentroTrabajoVistaBD.codTerritorio).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getCodTerritorio()));
		}
		//fin CENTRO DE TRABAJO
		//Inicio arbitro
		if(StringUtils.isNotEmpty(param.getArbitro())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.ARBITRO).append(" = ?");
			params.add(param.getArbitro());
		} 
		
		//Inicio sindicato
		if(StringUtils.isNotEmpty(param.getSindicato())){
			strSql.append(" AND ? IN (SELECT ").append(W83bImpugnacionesBD.codSindicatoSindi).append(" FROM ");
			strSql.append(W83bImpugnacionesBD.sindicatosImpugnacion).append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionSindi).append(" = ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.anyoImpugnacionSindi).append(" = ").append(W83bImpugnacionesVistaBD.anyoImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionSindi).append(" = ").append(W83bImpugnacionesVistaBD.numImpugnacion).append(" ) ");
			
			params.add(param.getSindicato());
		} 
		//Inicio resultado
		 
		if(StringUtils.isNotEmpty(param.getTipoVoz())){
			strSql.append(" AND ? IN (SELECT ").append(W83bImpugnacionesBD.codTipoVozVoces).append(" FROM ");
			strSql.append(W83bImpugnacionesBD.vocesImpugnacion).append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.anyoImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.anyoImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.numImpugnacion).append(" ) ");
			
			params.add(param.getTipoVoz());
			
			if(StringUtils.isNotEmpty(param.getVoz())){
				strSql.append(" AND ? IN (SELECT ").append(W83bImpugnacionesBD.codVozVoces).append(" FROM ");
				strSql.append(W83bImpugnacionesBD.vocesImpugnacion).append(" WHERE ");
				strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion);
				strSql.append(" AND ").append(W83bImpugnacionesBD.anyoImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.anyoImpugnacion);
				strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.numImpugnacion);
				strSql.append(" AND ").append(W83bImpugnacionesBD.codTipoVozVoces).append(" = ?").append(" ) ");
				
				params.add(param.getVoz());
				
				params.add(param.getTipoVoz());
			} 
		}
		//VOZ SI/NO
		if(StringUtils.isNotEmpty(param.getVozSINO())){
			strSql.append(" AND ? IN (SELECT ").append(W83bImpugnacionesBD.sinoVoces).append(" FROM ");
			strSql.append(W83bImpugnacionesBD.vocesImpugnacion).append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.anyoImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.anyoImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionVoces).append(" = ").append(W83bImpugnacionesVistaBD.numImpugnacion).append(" ) ");
			
			params.add(param.getVozSINO());
		} 
		if(StringUtils.isNotEmpty(param.getResultado())){
			strSql.append(" AND ").append(W83bImpugnacionesVistaBD.RESULTADO).append(" = ?");
			params.add(param.getResultado());
		}		
		
		
		//Inicio tramite
		
		if(StringUtils.isNotEmpty(param.getTramite())){
			strSql.append(" AND ? IN (SELECT ").append(W83bImpugnacionesBD.codTramite).append(" FROM ");
			strSql.append(W83bImpugnacionesBD.tramitesImpugnacion).append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionTram).append(" = ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.anyoImpugnacionTram).append(" = ").append(W83bImpugnacionesVistaBD.anyoImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionTram).append(" = ").append(W83bImpugnacionesVistaBD.numImpugnacion);
			strSql.append(" AND ").append(W83bImpugnacionesBD.codFase).append(" = ? ");
			params.add(param.getTramite());
			params.add(W83bClsConstantes.FASE_IMPUGNACION);
		
			
				
			if(StringUtils.isNotEmpty(param.getUltTramite())){
				strSql.append(" AND F_ACTU_071 = (select MAX(tram.F_ACTU_071) ");
				strSql.append(" FROM W83B71T00 tram WHERE tram.C_TERRIT_071 = ").append( W83bImpugnacionesVistaBD.codTerritorioImpugnacion);
				strSql.append(" AND tram.ANO_IMPUG_071 = ").append( W83bImpugnacionesVistaBD.anyoImpugnacion);
				strSql.append(" AND tram.N_IMPUG_071 = ").append(W83bImpugnacionesVistaBD.numImpugnacion).append(" ) ");
			}
			if(StringUtils.isNotEmpty(param.getFechaTramiteDel())){
					strSql.append(" AND ").append(W83bImpugnacionesBD.ftramite).append(" >= to_date(?,?)");
					params.add(param.getFechaTramiteDel());
					params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				}		
				
			if(StringUtils.isNotEmpty(param.getFechaTramiteHasta())){
					strSql.append(" AND ").append(W83bImpugnacionesBD.ftramite).append(" <= to_date(?,?)");
					params.add(param.getFechaTramiteHasta());
					params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				}	
			
			strSql.append(" ) ");
			
			
		} 
		//falta ultimo tramite
		
		
		
		//fin FECHA desestimiento
		resul.add(strSql);
		resul.add(params);
		return resul;
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public String contarImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT COUNT(");
		strSql.append(W83bImpugnacionesVistaBD.NIMPUGNACION).append(") ").append(" FROM ").append(W83bImpugnacionesVistaBD.impugnacionesSimpleView).append(" , ").append(W83bCentroTrabajoVistaBD.nombreVistaCompletoOpt);
		strSql.append(" WHERE ").append(" ").append(W83bImpugnacionesVistaBD.numImpugnacion).append(" > 0");
		strSql.append(" AND ").append(" ").append(W83bImpugnacionesVistaBD.IDCENTRO).append("= ").append(W83bCentroTrabajoVistaBD.codcentro);
		strSql.append("(+) ");
		
		List restoSql=((List)this.getBusquedaSql(param,params));
		strSql.append((StringBuffer)restoSql.get(0));
		params=(List)restoSql.get(1);
	
	
		List listaImpugnaciones = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaImpugnaciones.get(0).toString();	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#cargarCentroTrabajoPreaviso(java.util.HashMap)
	 */
	public java.util.List cargarCentroTrabajoPreaviso(HashMap mapaResultado) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		strSql.append(" ,");
		strSql.append(W83bActasBD.numRegDefinitivo);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.cifnif);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.nCentro);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.codMunicipio);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.codTerritorio);
		strSql.append(" , ");
		strSql.append(W83bCentroTrabajoVistaBD.razonsocial);
		
		strSql.append(" FROM ");
		strSql.append(W83bCentroTrabajoVistaBD.nombreVista);
		strSql.append(" , ");
		strSql.append(W83bPreavisosBD.preavisosTable);
		
		strSql.append(" , ");
		strSql.append(W83bActasBD.actasTable);
	
		strSql.append(" WHERE ");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro);
		strSql.append(" (+) = ");
		strSql.append(W83bPreavisosBD.id_centro_037);
		strSql.append(" AND ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(" (+) = ");
		strSql.append(W83bPreavisosBD.n_acta_037);
		strSql.append(" AND ");
		strSql.append(W83bActasBD.anyoActa);
		strSql.append(" (+)= ");
		strSql.append(W83bPreavisosBD.ano_acta_037);
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa);
		strSql.append(" (+)= ");
		strSql.append(W83bPreavisosBD.c_territ_037);
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_037);
		strSql.append(" = ? AND ");
		strSql.append(W83bPreavisosBD.c_territ_037);
		strSql.append(" = ? AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		strSql.append(" = ? ");
		params.add((String)mapaResultado.get("anio"));
		params.add((String)mapaResultado.get("cterritorio"));
		params.add((String)mapaResultado.get("num"));
		
		
		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		return listaDatosParametros;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#cargarCentroTrabajoActa(java.util.HashMap)
	 */
	public java.util.List cargarCentroTrabajoActa(HashMap mapaResultado) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(" ,");
		strSql.append(W83bActasBD.numRegDefinitivo);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.cifnif);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.nCentro);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.codMunicipio);
		strSql.append(" ,");
		strSql.append(W83bCentroTrabajoVistaBD.codTerritorio);
		strSql.append(" , ");
		strSql.append(W83bCentroTrabajoVistaBD.razonsocial);
		
		strSql.append(" FROM ");
		strSql.append(W83bCentroTrabajoVistaBD.nombreVista);
		strSql.append(" INNER JOIN ");
		strSql.append(W83bActasBD.actasTable);
		strSql.append(" ON ( ");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro);
		strSql.append(" = ");
		strSql.append(W83bActasBD.codCentro);
		strSql.append(" ) ");
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.codTerritActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" = ? ");
		params.add((String)mapaResultado.get("anio"));
		params.add((String)mapaResultado.get("cterritorio"));
		params.add((String)mapaResultado.get("num"));
		params.add(String.valueOf(W83bClsConstantes.ZERO));
		
		
		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		return listaDatosParametros;
	}

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#buscarSindicatos(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public List buscarSindicatos(w83b.w83bBeans.W83bImpugnacionBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bSindicatosBD.codSindicato).append(", ");
		strSql.append(W83bSindicatosBD.descSindicatoCast).append(", ");
		strSql.append(W83bSindicatosBD.descSindicatoEusk).append(", ");
		
		strSql.append(" FROM ").append(W83bSindicatosBD.sindicatosTable);
		strSql.append(" INNER JOIN ").append(W83bSindicatosImpugnacionBD.sindImpugTable);
		
		strSql.append(" ON (");
		strSql.append(W83bSindicatosImpugnacionBD.codSind).append(" = ").append(W83bSindicatosBD.codSindicato);
		
		strSql.append(" WHERE ").append(W83bSindicatosImpugnacionBD.territorio).append(" = ? ");
		strSql.append(" AND ").append(W83bSindicatosImpugnacionBD.anioImpug).append(" = ?");
		strSql.append(" AND ").append(W83bSindicatosImpugnacionBD.numimpug).append(" = ?");
		params.add(param.getTerritorioImpugnacion());
		params.add(param.getAnyoImpugnacion());
		params.add(param.getNumImpugnacion());
		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bSindicatosBean.class,null, param.getIdioma());
		
		return lista;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirSindicatos(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void anyadirSindicatos(W83bImpugnacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto los promotores
		if ("2".equals(param.getTipoImpugnacion()))
		{
			
		
			String[] cods = null;
			if (StringUtils.isNotEmpty(param.getCodsSindicatos()))
			{
				cods= param.getCodsSindicatos().split("\\?");	
				strSql= new StringBuffer();
				params= new ArrayList();
				strSql.append("INSERT INTO ");
				strSql.append(W83bImpugnacionesBD.sindicatosImpugnacion);
				strSql.append ("(");
				strSql.append(W83bImpugnacionesBD.numImpugnacionSindi);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.anyoImpugnacionSindi);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionSindi);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.codSindicatoSindi);
				strSql.append(")");
				strSql.append(" VALUES (?,?,?,?)");
				params.add(new Integer(param.getNumImpugnacion()));
				params.add(new Integer(param.getAnyoImpugnacion()));
				params.add(param.getTerritorioImpugnacion().toUpperCase());
	
				for (int i=0;i<cods.length;i++)
				{
					params.add(cods[i]);
					W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
					params.remove(params.size()-1);
				}
			}			
		}
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirVoces(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void anyadirVoces(W83bImpugnacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto los promotores
		
		String[] cods = null;
		if (StringUtils.isNotEmpty(param.getNumLaudo()) &&
				StringUtils.isNotEmpty(param.getAnyoLaudo()) &&
						StringUtils.isNotEmpty(param.getTerritorioLaudo()))
						{
			if (param.getCodsVoces()!=null && StringUtils.isNotEmpty(param.getCodsVoces()))
			{
				cods= param.getCodsVoces().split("\\?");	
				strSql= new StringBuffer();
				params= new ArrayList();
				strSql.append("INSERT INTO ");
				strSql.append(W83bImpugnacionesBD.vocesImpugnacion);
				strSql.append ("(");
				strSql.append(W83bImpugnacionesBD.numImpugnacionVoces);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.anyoImpugnacionVoces);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionVoces);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.numLaudoVoces);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.anyoLaudoVoces);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.codTipoVozVoces);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.codVozVoces);
				strSql.append(",");
				strSql.append(W83bImpugnacionesBD.sinoVoces);
				strSql.append(")");
				strSql.append(" VALUES (?,?,?,?,?,?,?,?)");
				params.add(new Integer(param.getNumImpugnacion()));
				params.add(new Integer(param.getAnyoImpugnacion()));
				params.add(param.getTerritorioImpugnacion().toUpperCase());
				params.add(new Integer(param.getNumLaudo()));
				params.add(new Integer(param.getAnyoLaudo()));

				for (int i=0;i<cods.length;i++)
				{
					String codigoCompleto=cods[i];
					String[] sep=codigoCompleto.split("\\|");
					Integer tipoVoz=new Integer(sep[0]);//NOPMD
					Integer voz=new Integer(sep[1]);//NOPMD
					Integer sino=new Integer(sep[2]);//NOPMD
					if(!existeVoz(param,tipoVoz,voz))
					{
						params.add(tipoVoz);
						params.add(voz);
						params.add(sino);
						W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
						params.remove(params.size()-1);
						params.remove(params.size()-1);
						params.remove(params.size()-1);
					}
					
				}
							
			}
						}
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirLaudo(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void anyadirLaudo(W83bImpugnacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto los promotores
		if (StringUtils.isNotEmpty(param.getNumLaudo()) &&
				StringUtils.isNotEmpty(param.getAnyoLaudo()) &&
						StringUtils.isNotEmpty(param.getTerritorioLaudo()))
						{
		
							String formatoFecha=W83bClsConstantes.FORMATO_FECHA_CASTELLANO;
							if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
							{
								formatoFecha=W83bClsConstantes.FORMATO_FECHA_EUSKARA;
							}
							strSql= new StringBuffer();
							params= new ArrayList();
							strSql.append("INSERT INTO ");
							strSql.append(W83bImpugnacionesBD.laudosImpugnacion);
							strSql.append ("(");
							strSql.append(W83bImpugnacionesBD.numImpugnacionLaudos);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.anyoImpugnacionLaudos);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionLaudos);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.numLaudoLaudos);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.anyoLaudoLaudos);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.fLaudoLaudos);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.resultadoLaudos);
							strSql.append(")");
							strSql.append(" VALUES (?,?,?,?,?,to_date(?,'"+formatoFecha+"'),?)");
							params.add(new Integer(param.getNumImpugnacion()));
							params.add(new Integer(param.getAnyoImpugnacion()));
							params.add(param.getTerritorioImpugnacion().toUpperCase());
							param.setNumLaudo(W83bUtilidades.rellenarCaracter(param.getNumLaudo(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.TRES,true));
							
							params.add(new Integer(param.getNumLaudo()));
							params.add(new Integer(param.getAnyoLaudo()));
							if (StringUtils.isNotEmpty(param.getFechaLaudo()))
								
								params.add(param.getFechaLaudo());
							else
								params.add(W83bClsConstantes.NULL_DATE);
							if (StringUtils.isNotEmpty(param.getResultado()))
								params.add(new Integer(param.getResultado()));
							else
								params.add(W83bClsConstantes.NULL_INTEGER);
				
							
							W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
							if(!existeTramite(param,W83bClsConstantes.CINCO,  W83bClsConstantes.CUATRO))
							{
								this.anyadirTramite(param, W83bClsConstantes.CINCO,  W83bClsConstantes.CUATRO,"");
							}
						
						}			
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#editarLaudo(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void editarLaudo(W83bImpugnacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		if(existeLaudo(param)){
			if (StringUtils.isNotEmpty(param.getNumLaudo()) &&
					StringUtils.isNotEmpty(param.getAnyoLaudo()) &&
							StringUtils.isNotEmpty(param.getTerritorioLaudo()))
							{
								String formatoFecha=W83bClsConstantes.FORMATO_FECHA_CASTELLANO;
								
								if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
								{
									formatoFecha=W83bClsConstantes.FORMATO_FECHA_EUSKARA;
								}
								strSql= new StringBuffer();
								params= new ArrayList();
								strSql.append("UPDATE  ");
								strSql.append(W83bImpugnacionesBD.laudosImpugnacion);
								strSql.append(" SET ");
								
								strSql.append(W83bImpugnacionesBD.fLaudoLaudos);
								strSql.append(" = to_date(?,'"+formatoFecha+"')");
								if (StringUtils.isNotEmpty(param.getFechaLaudo()))
									params.add(param.getFechaLaudo());
								else
									params.add(W83bClsConstantes.NULL_DATE);
								strSql.append(", ");
								strSql.append(W83bImpugnacionesBD.resultadoLaudos);
								strSql.append(" = ?");
								if (StringUtils.isNotEmpty(param.getResultado()))
									params.add(new Integer(param.getResultado()));
								else
									params.add(W83bClsConstantes.NULL_INTEGER);
								
								strSql.append(" WHERE ").append(W83bImpugnacionesBD.anyoImpugnacionLaudos).append(" = ? ");
								strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionLaudos).append(" = ? ");
								strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionLaudos).append(" = ? ");
								strSql.append(" AND ").append(W83bImpugnacionesBD.numLaudoLaudos).append(" = ? ");
								strSql.append(" AND ").append(W83bImpugnacionesBD.anyoLaudoLaudos).append(" = ? ");
								params.add(new Integer(param.getAnyoImpugnacion()));		
								params.add(new Integer(param.getNumImpugnacion()));
								params.add(param.getTerritorioImpugnacion());
								params.add(new Integer(param.getNumLaudo()));
								params.add(new Integer(param.getAnyoLaudo()));
								
								
					
								
								W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
									
							}		
		}else{
			anyadirLaudo(param);
		}
			
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirEmpresaImpugnante(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void anyadirEmpresaImpugnante(W83bImpugnacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto el impugnante
		if ("1".equals(param.getTipoImpugnacion()))
						{
		
		
							strSql= new StringBuffer();
							params= new ArrayList();
							strSql.append("INSERT INTO ");
							strSql.append(W83bImpugnacionesBD.impugnanteImpugnacion);
							strSql.append ("(");
							
							strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.numImpugnacionImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.anyoImpugnacionesImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.dniImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.nombreImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.dirImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.cpImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.provinciaImpugnante);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.municipioImpugnante);
							strSql.append(")");
							strSql.append(" VALUES (?,?,?,?,?,?,?,?,?)");
							params.add(param.getTerritorioImpugnacion().toUpperCase());
							params.add(new Integer(param.getNumImpugnacion()));
							params.add(new Integer(param.getAnyoImpugnacion()));
							if (StringUtils.isNotEmpty(param.getDniImpug()))
								params.add(param.getDniImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							if (StringUtils.isNotEmpty(param.getNombreImpug()))
								params.add(param.getNombreImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							if (StringUtils.isNotEmpty(param.getDirImpug()))
								params.add(param.getDirImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							if (StringUtils.isNotEmpty(param.getCpImpug()))
								params.add(param.getCpImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							if (StringUtils.isNotEmpty(param.getProvinciaImpug()))
								params.add(param.getProvinciaImpug());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							if (StringUtils.isNotEmpty(param.getMunicipioImpug()))
								params.add(param.getMunicipioImpug());
							else
								params.add(W83bClsConstantes.NULL_STRING);
						
							
							W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
								
						}		
		
	}
	/**
	 * Existe amite.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeTramite(W83bImpugnacionBean param,int fase, int tramite)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT * FROM ").append( W83bImpugnacionesBD. tramitesImpugnacion);
		
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.anyoImpugnacionTram).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionTram).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionTram).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.c_fase_071).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.c_tram_071).append(" = ? ");
		params.add(new Integer(param.getAnyoImpugnacion()));		
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		params.add(new Integer(fase));		
		params.add(new Integer(tramite));
		
		
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(lista.size()>0){
			return true;
		}
		
		return false;
	}

	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirTramite(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	
	public void anyadirTramite(W83bImpugnacionBean param, int fase, int tramite,String fechaRegistro) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
	
		params= new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bImpugnacionesBD.tramitesImpugnacion);
		strSql.append ("(");
		
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionTram);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.numImpugnacionTram);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionTram);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.c_fase_071);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.c_tram_071);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.ftramite);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.usu_71);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fechaAltaTramite);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"'),?,to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'))");
		params.add(param.getTerritorioImpugnacion().toUpperCase());
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(new Integer(param.getAnyoImpugnacion()));
		params.add(new Integer(fase));
		params.add(new Integer(tramite));
		//FACTU_037??
		SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO_PARSER);
		params.add(hoy.format(new Date()));
		
		//USUA??
		params.add(param.getUsuarioBean().getIdUsuario().toUpperCase());
		if(StringUtils.isNotEmpty(fechaRegistro)){
			params.add(fechaRegistro);
		}
		else{
			hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			params.add(hoy.format(new Date()));
		}
		
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			
						
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirTramite(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	
	public void editarTramite(W83bImpugnacionBean param, int fase, int tramite) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		
		params= new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bImpugnacionesBD.tramitesImpugnacion);
		strSql.append (" SET ");
		
		strSql.append(W83bImpugnacionesBD.fechamodif_71);
		strSql.append(" = to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"')");
		strSql.append(", ");
		strSql.append(W83bImpugnacionesBD.usumod_71);
		strSql.append(" = ?");
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionTram);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionTram);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionTram);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.c_fase_071);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.c_tram_071);
		strSql.append(" = ? ");
		
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario().toUpperCase());
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion().toUpperCase());
		params.add(new Integer(param.getAnyoImpugnacion()));
		params.add(new Integer(fase));
		params.add(new Integer(tramite));
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());		
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#editarEmpresaImpugnante(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void editarEmpresaImpugnante(W83bImpugnacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//meto el impugnante
		if ("1".equals(param.getTipoImpugnacion()))
						{
		
						if(existeImpugnante(param))
						{
							strSql= new StringBuffer();
							params= new ArrayList();
							strSql.append("UPDATE ");
							strSql.append(W83bImpugnacionesBD.impugnanteImpugnacion);
							strSql.append (" SET ");
							
							strSql.append(W83bImpugnacionesBD.dniImpugnante);
							strSql.append(" = ?");
							if (StringUtils.isNotEmpty(param.getDniImpug()))
								params.add(param.getDniImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							strSql.append(", ");
							strSql.append(W83bImpugnacionesBD.nombreImpugnante);
							strSql.append(" = ?");

							if (StringUtils.isNotEmpty(param.getNombreImpug()))
								params.add(param.getNombreImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.dirImpugnante);
							strSql.append(" = ?");
							if (StringUtils.isNotEmpty(param.getDirImpug()))
								params.add(param.getDirImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.cpImpugnante);
							strSql.append(" = ?");
							if (StringUtils.isNotEmpty(param.getCpImpug()))
								params.add(param.getCpImpug().toUpperCase());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.provinciaImpugnante);
							strSql.append(" = ?");
							if (StringUtils.isNotEmpty(param.getProvinciaImpug()))
								params.add(param.getProvinciaImpug());
							else
								params.add(W83bClsConstantes.NULL_STRING);
							strSql.append(",");
							strSql.append(W83bImpugnacionesBD.municipioImpugnante);
							strSql.append(" = ?");
							if (StringUtils.isNotEmpty(param.getMunicipioImpug()))
								params.add(param.getMunicipioImpug());
							else
								params.add(W83bClsConstantes.NULL_STRING);
						
							
							strSql.append(" WHERE ").append(W83bImpugnacionesBD.anyoImpugnacionesImpugnante).append(" = ? ");
							strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionImpugnante).append(" = ? ");
							strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionImpugnante).append(" = ? ");
							params.add(new Integer(param.getAnyoImpugnacion()));		
							params.add(new Integer(param.getNumImpugnacion()));
							params.add(param.getTerritorioImpugnacion());
							
							
					
							
							
							W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
						}else{
							anyadirEmpresaImpugnante(param);
						}
							
								
						}		
		
	}
	
	public String calcularNumImpugnacion(W83bImpugnacionBean param)throws Exception{
			
		if(StringUtils.isEmpty(param.getNumImpugnacion()))
		{
			StringBuffer strSqlCorrelativo = new StringBuffer();
			strSqlCorrelativo.append("SELECT MAX(");
			strSqlCorrelativo.append(W83bImpugnacionesBD.n_impug);
			strSqlCorrelativo.append(") FROM ");
			strSqlCorrelativo.append(W83bImpugnacionesBD.tableImpugnaciones);
			strSqlCorrelativo.append(" WHERE ").append(W83bImpugnacionesBD.ano_impug).append(" = ? ");
			strSqlCorrelativo.append(" AND ").append(W83bImpugnacionesBD.c_territ).append(" = ? ");
			
			List paramsCorrelativo=new ArrayList();
			paramsCorrelativo.add(new Integer(param.getAnyoImpugnacion()));
			paramsCorrelativo.add(param.getTerritorioImpugnacion());
			
			
			List idImpug= W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),paramsCorrelativo,null);
			int idImpugNext=1;
			
			if (idImpug!=null && idImpug.size()>0 && idImpug.get(0)!=null)
			{
				idImpugNext=Integer.parseInt(idImpug.get(0).toString())+1;
			}
			String next=Integer.toString(idImpugNext);
			
			param.setNumImpugnacion(W83bUtilidades.rellenarCaracter(next,String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true));
		}
		
		return param.getNumImpugnacion();
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public W83bImpugnacionBean anyadirImpugnaciones(W83bImpugnacionBean param) throws Exception {
		
		param.setNumImpugnacion(calcularNumImpugnacion(param));
			
		String formatoFecha=W83bClsConstantes.FORMATO_FECHA_CASTELLANO;
		String formatoFechaParser=W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER;
		String formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO;
		String formatoFechaCompletaParser=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO_PARSER;
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
		{
			formatoFecha=W83bClsConstantes.FORMATO_FECHA_EUSKARA;
			formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA;
			formatoFechaParser=W83bClsConstantes.FORMATO_FECHA_EUSKARA_PARSER;
			formatoFechaCompletaParser=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA_PARSER;
		}
		
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bImpugnacionesBD.tableImpugnaciones);
		
		strSql.append("(");
		
		strSql.append(W83bImpugnacionesBD.ano_impug);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.n_impug);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.c_territ);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.f_impug);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.n_preaviso);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.ano_preaviso);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.n_acta);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.ano_acta);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.version);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.dniArbitro);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.c_impug);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fenvarb);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fdeses);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fenvjuz);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fsenten);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.asunto);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.decision);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.usuario);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.factu);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.nregistro);
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fregistro);
		
		strSql.append(")");
		
		strSql.append(" VALUES (?,?,?,to_date(?,'"+formatoFecha+"')," +
				"?,?,?,?,?,?,?,to_date(?,'"+formatoFecha+"')," +
						"to_date(?,'"+formatoFecha+"')," +
								"to_date(?,'"+formatoFecha+"')," +
										"to_date(?,'"+formatoFecha+"')" +
												",?,?,?," +
												"to_date(?,'"+formatoFechaCompleta+"')"+
												",?," +
												"to_date(?,'"+formatoFechaCompleta+"'))");
		params.add(new Integer(param.getAnyoImpugnacion()));
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion().toUpperCase());
		if (StringUtils.isNotEmpty(param.getFechaImpugnacion())){
			params.add(param.getFechaImpugnacion());
		
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(param.getActaPreaviso().equals("preaviso"))
		{
			param.setNumPreaviso(W83bUtilidades.rellenarCaracter(param.getNumPreaviso(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true));
			
			params.add(new Integer(param.getNumPreaviso()));
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
		}else if(param.getActaPreaviso().equals("acta"))
		{
			param.setNumActa(W83bUtilidades.rellenarCaracter(param.getNumActa(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true));
			
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(new Integer(param.getNumActa()));
			params.add(new Integer(param.getAnyoActa()));
			params.add(new Integer(W83bClsConstantes.ZERO));
			
			
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		
		if (StringUtils.isNotEmpty(param.getArbitro())){
			params.add(param.getArbitro().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getTipoImpugnacion())){
			params.add(param.getTipoImpugnacion());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getFechaEnvioArbitro())){
			params.add(param.getFechaEnvioArbitro());
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getFechaDesestimiento())){
			params.add(param.getFechaDesestimiento());
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getFechaEnvioJuzgado())){
			params.add(param.getFechaEnvioJuzgado());
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getFechaSentencia())){
			params.add(param.getFechaSentencia());
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getAsunto())){
			params.add(param.getAsunto().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDecision())){
			params.add(param.getDecision().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		
		//USUA??
		params.add(param.getUsuarioBean().getIdUsuario().toUpperCase());
		
		//FACTU_037??
		SimpleDateFormat hoy =new SimpleDateFormat(formatoFechaCompletaParser);
		params.add(hoy.format(new Date()));
		
		if ("1".equals(param.getUsuarioBean().getRegManual()))
		{
			//Numero de registro
			if (StringUtils.isNotEmpty(param.getNum_registro())){
				params.add(param.getNum_registro());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			
			//Fecha de registro
			if (StringUtils.isNotEmpty(param.getFecha_registro()))
				params.add(param.getFecha_registro());
			else
				params.add(W83bClsConstantes.NULL_DATE);
		}
		else
		{
			params.add(W83bClsConstantes.NULL_STRING);
			params.add(W83bClsConstantes.NULL_DATE);
		}
		
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		if ("0".equals(param.getUsuarioBean().getRegManual()))
		{
			//libro de registro
			 String observaciones="Impugnaciones n: "+param.getTerritorioImpugnacion()+"/"+param.getAnyoImpugnacion()+"/"+param.getNumImpugnacion();
			 String empresa="";
			 if(param.getTipoImpugnacion().equals("1"))
			 {
				 empresa=param.getDniImpug();
			 }else if(param.getTipoImpugnacion().equals("2"))
			 {
				 empresa=(String)param.getCodsSindicatos().split("\\?")[0];
			 }
			
			try{
				String [] resul=W83bLibroRegistro.getAltaRegistro(true, param.getUsuarioBean().getModelo(), "E", "E", empresa, param.getTerritorioImpugnacion(), "", observaciones, param.getUsuarioBean());
				strSql = new StringBuffer();
				params = new ArrayList();
			
				param.setFecha_registro(resul[1]);
				param.setNum_registro(resul[0]);
			 
			strSql.append("UPDATE ") ;
			strSql.append(W83bImpugnacionesBD.tableImpugnaciones);
			strSql.append(" SET ");
			strSql.append(W83bImpugnacionesBD.fregistro);
			strSql.append(" = to_date(?,'dd/MM/yy hh24:mi:ss')");
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.nregistro);
			strSql.append(" = ?");
			strSql.append(" WHERE ").append(W83bImpugnacionesBD.ano_impug).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.n_impug).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.c_territ).append(" = ? ");
			
			params.add(param.getFecha_registro());
			params.add(param.getNum_registro());
			
			params.add(new Integer(param.getAnyoImpugnacion()));
			params.add(new Integer(param.getNumImpugnacion()));
			params.add(param.getTerritorioImpugnacion());
			
			W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			SimpleDateFormat sencillo =new SimpleDateFormat(formatoFechaParser);
			SimpleDateFormat formato=new SimpleDateFormat("dd/MM/yy hh:mm:ss");
			
			
			param.setNum_registro(param.getNum_registro());

			param.setFecha_registro(sencillo.format(formato.parse(param.getFecha_registro())));
			}catch (W83bLibroRegistroException e) {
				// TODO: handle exception
			}
		}
		
		//dar de alta en el historial
		CallableStatement cs;
	    cs = W83bDataBase.getConnection().prepareCall("{call w83b.w83bHistorialImpugnaciones(?,?,?,?,?,?,?)}");
	    cs.setInt(1, Integer.parseInt(param.getNumImpugnacion()));
	    cs.setInt(2, Integer.parseInt(param.getAnyoImpugnacion()));
	    cs.setString(3, param.getTerritorioImpugnacion().toUpperCase());
	    cs.setString(4, W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, param.getUsuarioBean().getIdUsuario());
	    cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertimpugnacion", W83bClsConstantes.CONSTANTE_CASTELLANO));
	    cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertimpugnacion", W83bClsConstantes.CONSTANTE_EUSKARA));
	    cs.execute();
		return param;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#editarImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void editarImpugnaciones(W83bImpugnacionBean param) throws Exception {
		
		String formatoFecha=W83bClsConstantes.FORMATO_FECHA_CASTELLANO;
		String formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO;
		String formatoFechaCompletaParser=W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO_PARSER;
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
		{
			formatoFecha=W83bClsConstantes.FORMATO_FECHA_EUSKARA;
			formatoFechaCompleta=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA;
			formatoFechaCompletaParser=W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA_PARSER;
		}
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bImpugnacionesBD.tableImpugnaciones);
		
		strSql.append(" SET ");
		
		
		strSql.append(W83bImpugnacionesBD.f_impug);
		strSql.append(" = to_date(?,'"+formatoFecha+"')");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.n_preaviso);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.ano_preaviso);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.n_acta);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.ano_acta);
		strSql.append(" = ? ");
		//20150907 en caso que se edite la impugnacion la version se actualizar
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.version);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.dniArbitro);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.c_impug);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fenvarb);
		strSql.append(" = to_date(?,'"+formatoFecha+"')");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fdeses);
		strSql.append(" = to_date(?,'"+formatoFecha+"')");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fenvjuz);
		strSql.append(" = to_date(?,'"+formatoFecha+"')");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.fsenten);
		strSql.append(" = to_date(?,'"+formatoFecha+"')");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.asunto);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.decision);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.usuario);
		strSql.append(" = ? ");
		strSql.append(",");
		strSql.append(W83bImpugnacionesBD.factu);
		strSql.append(" = to_date(?,'"+formatoFechaCompleta+"')");
		
		/*mejoras flex1if ("1".equals(param.getUsuarioBean().getRegManual()))
		{*/
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.nregistro);
			strSql.append(" = ? ");
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.fregistro);
			strSql.append(" = to_date(?,'"+formatoFechaCompleta+"')");
			
		//}
		
		
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.ano_impug).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.n_impug).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.c_territ).append(" = ? ");
		
		
		
		
		
		params.add(param.getFechaImpugnacion());
		if(param.getActaPreaviso().equals("preaviso"))
		{
			param.setNumPreaviso(W83bUtilidades.rellenarCaracter(param.getNumPreaviso(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true));
			
			params.add(new Integer(param.getNumPreaviso()));
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(param.getActaPreaviso().equals("acta"))
		{
			param.setNumActa(W83bUtilidades.rellenarCaracter(param.getNumActa(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true));
			
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(W83bClsConstantes.NULL_INTEGER);
			params.add(new Integer(param.getNumActa()));
			params.add(new Integer(param.getAnyoActa()));
//			20150907 en caso que se edite la impugnacion la version se actualizar
			if (param.getVersionActa()==null || (param.getVersionActa()!=null && param.getVersionActa().equals("")))
				params.add(new Integer(W83bClsConstantes.ZERO));
			else
				params.add(new Integer(param.getVersionActa()));
			
			
		}
		
		if (StringUtils.isNotEmpty(param.getArbitro()))
			params.add(param.getArbitro().toUpperCase());
		else
			params.add(W83bClsConstantes.NULL_STRING);
		if (StringUtils.isNotEmpty(param.getTipoImpugnacion()))
			params.add(param.getTipoImpugnacion());
		else
			params.add(W83bClsConstantes.NULL_INTEGER);
		if (StringUtils.isNotEmpty(param.getFechaEnvioArbitro()))
			params.add(param.getFechaEnvioArbitro());
		else
			params.add(W83bClsConstantes.NULL_DATE);
		if (StringUtils.isNotEmpty(param.getFechaDesestimiento()))
			params.add(param.getFechaDesestimiento());
		else
			params.add(W83bClsConstantes.NULL_DATE);
		if (StringUtils.isNotEmpty(param.getFechaEnvioJuzgado()))
			params.add(param.getFechaEnvioJuzgado());
		else
			params.add(W83bClsConstantes.NULL_DATE);
		if (StringUtils.isNotEmpty(param.getFechaSentencia()))
			params.add(param.getFechaSentencia());
		else
			params.add(W83bClsConstantes.NULL_DATE);
		if (StringUtils.isNotEmpty(param.getAsunto()))
			params.add(param.getAsunto().toUpperCase());
		else
			params.add(W83bClsConstantes.NULL_STRING);
		if (StringUtils.isNotEmpty(param.getDecision()))
			params.add(param.getDecision().toUpperCase());
		else
			params.add(W83bClsConstantes.NULL_STRING);
		
		
		
		//USUA??
		params.add(param.getUsuarioBean().getIdUsuario().toUpperCase());
		//FACTU_037??
		
		SimpleDateFormat hoy =new SimpleDateFormat(formatoFechaCompletaParser);
		params.add(hoy.format(new Date()));
		
		/*mejoras flex1if ("1".equals(param.getUsuarioBean().getRegManual()))
		{*/

			//Numero de registro
			if (StringUtils.isNotEmpty(param.getNum_registro()))
				params.add(param.getNum_registro());
			else
				params.add(W83bClsConstantes.NULL_STRING);
			
			
			//Fecha de registro
			if (StringUtils.isNotEmpty(param.getFecha_registro())){
				
				params.add(param.getFecha_registro());
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			
			
		//}
		
		
		params.add(new Integer(param.getAnyoImpugnacion()));		
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		

		//dar de alta en el historial
		CallableStatement cs;
	    cs = W83bDataBase.getConnection().prepareCall("{call w83b.w83bHistorialImpugnaciones(?,?,?,?,?,?,?)}");
	    cs.setInt(1, Integer.parseInt(param.getNumImpugnacion()));
	    cs.setInt(2, Integer.parseInt(param.getAnyoImpugnacion()));
	    cs.setString(3, param.getTerritorioImpugnacion().toUpperCase()); 
	    cs.setString(4, W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, param.getUsuarioBean().getIdUsuario());
	    cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.editimpugnacion", W83bClsConstantes.CONSTANTE_CASTELLANO));
	    cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.editimpugnacion", W83bClsConstantes.CONSTANTE_EUSKARA));
	    cs.execute();
	    
	   
		
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#cargaTiposDocumento(java.util.HashMap)
	 */
	public List cargaTiposDocumento(HashMap param) throws Exception {
		List listaFasesTramites=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		W83bDatosFasesTramitesBean datos;
		List lista=new ArrayList();
		if (param.get("numImpugnacion")!=null)
		{
			//tengo que sacar los tramites y fases por los que ha pasado el preaviso
			
			strSql.append("SELECT ");
			strSql.append(W83bImpugnacionesBD.c_fase_071);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.c_tram_071);
			strSql.append(" FROM ");
			strSql.append(W83bImpugnacionesBD.tramitesImpugnacion);
			strSql.append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.n_impug_071).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesBD.ano_impug_071).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesBD.c_territ_071).append(" = ?");
			strSql.append(" ORDER BY ");
			strSql.append(W83bImpugnacionesBD.c_tram_071).append(" DESC");
			String [] numImpug=((String)param.get("numImpugnacion")).split("_");
			
			params.add(new Integer(numImpug[2]));
			params.add(new Integer(numImpug[1]));
			params.add(numImpug[0]);
			
			listaFasesTramites=W83bDataBase.executeQuery(strSql.toString(),params,W83bDatosFasesTramitesBean.class,null, "impugnaciones");
			
			if(listaFasesTramites==null || listaFasesTramites.isEmpty())
			{
				datos=new W83bDatosFasesTramitesBean();
				datos.setCodFase(String.valueOf(W83bClsConstantes.CINCO));
				datos.setCodTramite(String.valueOf(W83bClsConstantes.UNO));
				lista.add(datos);
				datos=new W83bDatosFasesTramitesBean();
				datos.setCodFase(String.valueOf(W83bClsConstantes.CINCO));
				datos.setCodTramite(String.valueOf(W83bClsConstantes.NOVENTAYNUEVE));
				lista.add(datos);
			}else{
				boolean laudo=false;
				for(int i=0;i<listaFasesTramites.size()&& !laudo;i++)
				{
					if(((W83bDatosFasesTramitesBean)listaFasesTramites.get(i)).getCodTramite().equals(String.valueOf(W83bClsConstantes.CUATRO))
							|| ((W83bDatosFasesTramitesBean)listaFasesTramites.get(i)).getCodTramite().equals(String.valueOf(W83bClsConstantes.UNO)))
					{
						lista.add(((W83bDatosFasesTramitesBean)listaFasesTramites.get(i)));
						laudo=true;
						datos=new W83bDatosFasesTramitesBean();//NOPMD
						datos.setCodFase(String.valueOf(W83bClsConstantes.CINCO));
						datos.setCodTramite(String.valueOf(W83bClsConstantes.NOVENTAYNUEVE));
						lista.add(datos);
					}
				}
				
			}
		}
		else
		{
			 datos=new W83bDatosFasesTramitesBean();
			datos.setCodFase(String.valueOf(W83bClsConstantes.CINCO));
			datos.setCodTramite(String.valueOf(W83bClsConstantes.UNO));
			lista.add(datos);
			datos=new W83bDatosFasesTramitesBean();
			datos.setCodFase(String.valueOf(W83bClsConstantes.CINCO));
			datos.setCodTramite(String.valueOf(W83bClsConstantes.NOVENTAYNUEVE));
			lista.add(datos);
		}
		//obtengo los documentos
		strSql = new StringBuffer();
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bTiposDocumentosVistaBD.tipoDocFasTram);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.fase);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.tramite);
		strSql.append(",");
		if (param.get("strIdioma").equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
				strSql.append(W83bTiposDocumentosVistaBD.descFase).append(" AS DESCFASE , ");
				strSql.append(W83bTiposDocumentosVistaBD.descTramite).append(" AS DESCTRAMITE, ");
				strSql.append(W83bTiposDocumentosVistaBD.descTipoDoc).append(" AS DESCRIPCION ");
		}else{
				strSql.append(W83bTiposDocumentosVistaBD.deseFase).append(" AS DESCFASE , ");
				strSql.append(W83bTiposDocumentosVistaBD.deseTramite).append(" AS DESCTRAMITE, ");
				strSql.append(W83bTiposDocumentosVistaBD.deseTipoDoc).append(" AS DESCRIPCION ");
			}
		
		strSql.append(" FROM ");
		strSql.append(W83bTiposDocumentosVistaBD.vista);
		strSql.append(" WHERE ");
		strSql.append(W83bTiposDocumentosVistaBD.tramite).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bTiposDocumentosVistaBD.fase).append(" = ?");
		W83bDatosFasesTramitesBean datosFases=null;
		List listaTiposDocsAux=null;
		List listaTiposDocsResult=new ArrayList();
		for (int i=0;i<lista.size();i++)
		{
			datosFases=(W83bDatosFasesTramitesBean)lista.get(i);
			params.add(new Integer(datosFases.getCodTramite()));//NOPMD
			params.add(new Integer(datosFases.getCodFase()));//NOPMD
			listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bTipoDocumentoBean.class,null, "impugnaciones");
			for (int j=0;j<listaTiposDocsAux.size();j++)
			{
				listaTiposDocsResult.add(listaTiposDocsAux.get(j));
			}
			params.clear();
		}
		
		return listaTiposDocsResult;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#adjuntarArchivoImpugnaciones(java.util.HashMap)
	 */
	public String adjuntarArchivoImpugnaciones(HashMap param) throws Exception {
		// TODO insertar archivo en la tabla correspondiente
		return "ok";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#obtenerDatosBasicosImpugnacion(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public W83bImpugnacionBean obtenerDatosBasicosImpugnacion(String codSelec,String idioma, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		
		String [] cod=codSelec.split("_");
		
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesVistaBD.NIMPUGNACION).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NPREAVISO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoPreaviso).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numPreaviso).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoActa).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numActa).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.VERSION).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NACTA).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fimpugnacionDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FIMPUGNACION).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NOMBREARBITRO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.ARBITRO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fenvioarbitroDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FENVIOARBITRO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fdesestimientoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FDESESTIMIENTO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fenviojuzgadoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FENVIOJUZGADO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fsentenciaDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FSENTENCIA).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.asunto).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.decision).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.anyoLaudo).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.numLaudo).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NLAUDO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.flaudoDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FLAUDO).append(", ");
		
		strSql.append(W83bImpugnacionesVistaBD.RESULTADO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESCRESULTADO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESERESULTADO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.TIPOIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESETIPOIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESCTIPOIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NREGISTRO).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesVistaBD.fregistroDate).append(",?) AS ").append(W83bImpugnacionesVistaBD.FREGISTRO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.CODVOCES).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESCVOCES).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESEVOCES).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.CODSINDICATOS).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DESCSINDICATOS).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NCENTRO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.RAZONSOCIAL).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.codProvincia).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.codMunicipio).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.centroProvinciaTxtC).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.centroProvinciaTxtE).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.centroMunicipioTxtC).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.centroMunicipioTxtE).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.IDCENTRO).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.CIF).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DNIIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.NOMBREIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.DIRIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.CPIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.MUNIIMPUG).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.MUNIIMPUGTXTC).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.PROVIMPUGTXTC).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.MUNIIMPUGTXTE).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.PROVIMPUGTXTE).append(", ");
		strSql.append(W83bImpugnacionesVistaBD.PROVIMPUG);

		
		
		strSql.append(" FROM ").append(W83bImpugnacionesVistaBD.impugnacionesView);
		
		strSql.append(" WHERE ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(" = ?");
		
			
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bImpugnacionBean.class,null, null);
		((W83bImpugnacionBean)lista.get(0)).setCodSelec(codSelec);
		
		CallableStatement cs;
		cs = W83bDataBase.getConnection().prepareCall("{call w83b.w83bHistorialImpugnaciones(?,?,?,?,?,?,?)}");
		cs.setInt(1, Integer.parseInt(cod[2]));
		cs.setInt(2, Integer.parseInt(cod[1]));
		cs.setString(3, cod[0]);
		 cs.setString(4, W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, usuarioBean.getIdUsuario());
		cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.accesoimpugnacion", W83bClsConstantes.CONSTANTE_CASTELLANO));
		cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.accesoimpugnacion", W83bClsConstantes.CONSTANTE_EUSKARA));
		cs.execute();
		return ((W83bImpugnacionBean)lista.get(0));
}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#obtenerTramitesImpugnacion(java.lang.String)
	 */
	public W83bImpugnacionBean obtenerTramitesImpugnacion(String codSelec,String idioma)
	throws Exception {
		
		String [] cod=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83bImpugnacionesBD.cod_fase).append(", ");
		strSql.append(W83bImpugnacionesBD.desc_fase).append (" AS DESC_FASE").append(", ");
		strSql.append(W83bImpugnacionesBD.dese_fase).append (" AS DESE_FASE").append(", ");
		strSql.append(W83bImpugnacionesBD.desc_tramite).append (" AS DESC_TRAMITE").append(", ");
		strSql.append(W83bImpugnacionesBD.dese_tramite).append (" AS DESE_TRAMITE").append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesBD.f_actu_tramite).append(",?) AS "+W83bImpugnacionesBD.f_actu_tramite+", ");
		strSql.append(W83bImpugnacionesBD.usu_alta).append(", TO_CHAR(");
		strSql.append(W83bImpugnacionesBD.fecha_alta_tramite).append(",?) AS "+W83bImpugnacionesBD.fecha_alta_tramite+", ");
		strSql.append(W83bImpugnacionesBD.usu_mod).append(",  TO_CHAR(");
		strSql.append(W83bImpugnacionesBD.fecha_mod).append(",?) AS "+W83bImpugnacionesBD.fecha_mod+", ");
		strSql.append(W83bImpugnacionesBD.fecha_reg_salida).append(", ");
		strSql.append(W83bImpugnacionesBD.num_reg_salid);
		

		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		strSql.append(" FROM ").append(W83bImpugnacionesBD.vista_historial_tramitacion);
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.codTerritorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyo_impug).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.num_impug).append(" = ?");
		strSql.append(" ORDER BY ").append(W83bImpugnacionesBD.vista_historial_tramitacion).append(".").append(W83bImpugnacionesBD.fecha_alta_tramite).append( " ASC ");

		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		List listaTramites = W83bDataBase.executeQuery(strSql.toString(),params,W83bTramiteImpugnacionBean.class,null, null);
			
		W83bImpugnacionBean resultado=new W83bImpugnacionBean();
		resultado.setListaTramites(listaTramites);
		return resultado;
}

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarImpugnacion(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarImpugnacion(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.tableImpugnaciones);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.c_territ);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.n_impug);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarImpugnante(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarImpugnante(W83bImpugnacionBean param) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codImpugnacion=param.getCodSelec().split("_");

		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.impugnanteImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionImpugnante);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionesImpugnante);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionImpugnante);
		strSql.append(" = ? ");
		
			params.add(codImpugnacion[2]);
			params.add(codImpugnacion[1]);
			params.add(codImpugnacion[0]);
			
			
			W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
			
		
	    
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarTramitesImpugnacion(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTramitesImpugnacion(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.tramitesImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.c_territ_071);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug_071);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.n_impug_071);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			W83bClsTrazas.trazaError(null, "Error al dar de baja Impugnacion-> "+e.getMessage(),null);
			return false;
		}
	    
		return true;
	}
	
	public boolean borrarTramiteLaudo(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.tramitesImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.c_territ_071);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug_071);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.n_impug_071);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.codTramite);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.codFase);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		params.add(new Integer(W83bClsConstantes.TRAMITE_RESOLUCION_LAUDO));
		params.add(new Integer(W83bClsConstantes.TRAMITE_NOTIFICACION_RESOLUCION_LAUDO));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			W83bClsTrazas.trazaError(null, "Error al dar de baja trmite laudo-> "+e.getMessage(),null);
			return false;
		}
	    
		return true;
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarDocsImpugnaciones(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarDocsImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.impugnaciones_docsTable);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.c_territ_041);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug_041);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.n_impug_041);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
		return true;
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarSindicatos(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarSindicatos(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.sindicatosImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionSindi);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionSindi);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionSindi);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			W83bClsTrazas.trazaError(null, "Error al dar de baja Impugnacion-> "+e.getMessage(),null);
			return false;
		}
		

		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarVoces(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarVoces(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.vocesImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionVoces);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionVoces);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionVoces);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			W83bClsTrazas.trazaError(null, "Error al dar de baja Impugnacion-> "+e.getMessage(),null);
			return false;
		}
		

		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarLaudo(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarLaudo(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.laudosImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionLaudos);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionLaudos);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionLaudos);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			W83bClsTrazas.trazaError(null, "Error al dar de baja Impugnacion-> "+e.getMessage(),null);
			return false;
		}
		

		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarEmpresaImpugnante(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarEmpresaImpugnante(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.impugnanteImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionImpugnante);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionesImpugnante);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionImpugnante);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			W83bClsTrazas.trazaError(null, "Error al dar de baja Impugnacion-> "+e.getMessage(),null);
			return false;
		}
		

		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarHistorial(java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarHistorial(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] cod=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.impugncion_historial_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.c_territ_073);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug_073);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.n_impug_073);
		strSql.append(" = ? ");
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			W83bClsTrazas.trazaError(null, "Error al dar de baja Impugnacion-> "+e.getMessage(),null);
			return false;
		}
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#obtenerDocsImpugnacion(java.lang.String)
	 */
	public W83bImpugnacionBean obtenerDocsImpugnacion(String codSelec, String idioma) throws Exception {
		String [] codImpugnacion=codSelec.split("_");

		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesBD.id_docu_041).append(", ");
		strSql.append(W83bImpugnacionesBD.nomb_docu_041).append(", ");
		strSql.append(W83bImpugnacionesBD.docu_041).append(", ");
		strSql.append(W83bImpugnacionesBD.c_territ_041).append(", ");
		strSql.append(W83bImpugnacionesBD.ano_impug_041).append(", ");
		strSql.append(W83bImpugnacionesBD.n_impug_041).append(", ");
		strSql.append(W83bImpugnacionesBD.tp_doc_041).append(", ");
		strSql.append(W83bImpugnacionesBD.id_remesa_acuse_041).append(", ");
		strSql.append(W83bImpugnacionesBD.cod_remesa_acuse_041).append(", ");
		strSql.append(W83bImpugnacionesBD.id_coleccion_acuse_041).append(", ");
		strSql.append(W83bImpugnacionesBD.cod_coleccion_acuse_041).append(", ");
		strSql.append(W83bImpugnacionesBD.id_envio_acuse_041).append(", ");
		strSql.append(W83bImpugnacionesBD.cod_envio_acuse_041).append(", ");
		strSql.append(W83bTramitesBD.nomTramite_Cast).append(", ");
		strSql.append(W83bTramitesBD.nomTramite_Eusk).append(", ");
		strSql.append(W83bImpugnacionesBD.num_reg_041).append(", TO_CHAR(  ");
		strSql.append(W83bImpugnacionesBD.f_reg_041).append(",?) AS ").append(W83bImpugnacionesBD.f_reg_041).append(", ");
		strSql.append(W83bPreavisosBD.desc_cas_069).append(", ");
		strSql.append(W83bPreavisosBD.desc_eus_069).append(", ");
		strSql.append(W83bImpugnacionesBD.usuario_041);

		strSql.append(" FROM ").append(W83bImpugnacionesBD.vistaDocsImpug);
		
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.c_territ_041).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug_041).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.n_impug_041).append(" = ?");
		
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(new String(codImpugnacion[0]));		
		params.add(new Integer(codImpugnacion[1]));
		params.add(new Integer(codImpugnacion[2]));
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBeanImpug.class,null, null);
		
		W83bImpugnacionBean resultado=new W83bImpugnacionBean();
		resultado.setListaDocs(listaDocumentos);
		return resultado;

		
	
	}

	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#obtenerHistorialImpugnacion(java.lang.String)
	 */
	public W83bImpugnacionBean obtenerHistorialImpugnacion(String codSelec,String idioma)
			throws Exception {
		
		String [] codImpugnacion=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(" TO_CHAR(").append(W83bImpugnacionesBD.factu_073).append(",?) AS ").append(W83bImpugnacionesBD.factu_073).append(", ");
			
		
		//TODO cambiar a que llegue el idioma
		strSql.append(W83bImpugnacionesBD.desc_cas_073).append(" AS DESCRIPCIONC , ");
		strSql.append(W83bImpugnacionesBD.desc_eus_073).append(" AS DESCRIPCIONE , ");

		strSql.append(W83bImpugnacionesBD.usua_073);

		
		strSql.append(" FROM ").append(W83bImpugnacionesBD.impugncion_historial_Synonym);
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.c_territ_073).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug_073).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesBD.n_impug_073).append(" = ?");
		strSql.append(" ORDER BY ").append(W83bImpugnacionesBD.impugncion_historial_Synonym).append(".").append(W83bImpugnacionesBD.factu_073).append( " DESC ");
		if(idioma.equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
			params.add(W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO);
		}else{
			params.add(W83bClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA);
		}
		
		params.add(new String(codImpugnacion[0]));		
		params.add(new Integer(codImpugnacion[1]));
		params.add(new Integer(codImpugnacion[2]));
		
		List listaHistorial = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistorialImpugnacionBean.class,null, null);
		
		W83bImpugnacionBean resultado=new W83bImpugnacionBean();
		resultado.setListaHistorial(listaHistorial);
		return resultado;	
		
	}

	

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarSindicatosImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void borrarSindicatosImpugnaciones(W83bImpugnacionBean param)
			throws Exception {
		String [] codImpugnacion=param.getCodSelec().split("_");

	
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bImpugnacionesBD.sindicatosImpugnacion);
			strSql.append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.numImpugnacionSindi).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesBD.anyoImpugnacionSindi).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionSindi).append(" = ?");
			
				params.add(codImpugnacion[2]);
				params.add(codImpugnacion[1]);
				params.add(codImpugnacion[0]);
				
				
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			
	
		
	}

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarVoces(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void borrarVoces(W83bImpugnacionBean param)throws Exception {
		String [] codImpugnacion=param.getCodSelec().split("_");
		
		
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bImpugnacionesBD.vocesImpugnacion);
			strSql.append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.numImpugnacionVoces).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesBD.anyoImpugnacionVoces).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionVoces).append(" = ?");
	
			
			
			
				params.add(codImpugnacion[2]);
				params.add(codImpugnacion[1]);
				params.add(codImpugnacion[0]);
			
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				
			
		

	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#descargarDocumento(java.lang.String)
	 */
	public W83bDocBeanImpug descargarDocumento(String param) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesBD.nomb_docu_041).append(",");
		strSql.append(W83bImpugnacionesBD.long_docu_041).append(",");
		strSql.append(W83bImpugnacionesBD.docu_041);
		strSql.append(" FROM ").append(W83bImpugnacionesBD.impugnaciones_docsTable);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.id_docu_041).append(" = ?");
		
		params.add(param);		
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBeanImpug.class,null, null);
		
		if (listaDocumentos.size()>0)
			return (W83bDocBeanImpug)listaDocumentos.get(0);
		else
			throw new Exception("No existe ese documento");

		

	}


	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#insertarDocsImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public String insertarDocsImpugnaciones(W83bImpugnacionBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		String resultado = "";
		
		
		//voy a insertar los documentos adjuntos
		if (param.getListaDocs()!=null && param.getListaDocs().size()>0)
		{
			
			String formatoFecha=W83bClsConstantes.FORMATO_FECHA_CASTELLANO;
		
			if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_EUSKARA))
			{
				formatoFecha=W83bClsConstantes.FORMATO_FECHA_EUSKARA;
				
			}
			strSql = new StringBuffer();
			

			StringBuffer strSqlCorrelativo = new StringBuffer();
			strSqlCorrelativo.append("SELECT MAX(");
			strSqlCorrelativo.append(W83bImpugnacionesBD.id_docu_041);
			strSqlCorrelativo.append(") FROM ");
			strSqlCorrelativo.append(W83bImpugnacionesBD.impugnaciones_docsTable);
			
			List idDoc = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
			int idDocNext=1;
			
			if (idDoc!=null && idDoc.size()>0 && idDoc.get(0)!=null)
			{
				idDocNext=Integer.parseInt(idDoc.get(0).toString())+1;
			}
			strSql = new StringBuffer();
			params = new ArrayList();

			strSql.append("INSERT INTO ");
			strSql.append(W83bImpugnacionesBD.impugnaciones_docsTable);
			
			strSql.append("(");
			strSql.append(W83bImpugnacionesBD.id_docu_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.nomb_docu_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.long_docu_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.docu_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.c_territ_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.c_tram_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.c_fase_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.ano_impug_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.n_impug_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.tp_doc_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.num_reg_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.f_reg_041);
			strSql.append(",");
			strSql.append(W83bImpugnacionesBD.usuario_041);
			strSql.append(")");
			

			strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,to_date(?, '"+formatoFecha+"'),?)");
			
			
			StringBuffer strSqlLibro = new StringBuffer();
			ArrayList paramsLibro = new ArrayList();
			 
			strSqlLibro.append("UPDATE ") ;
			strSqlLibro.append(W83bImpugnacionesBD.impugnaciones_docsTable);
			strSqlLibro.append(" SET ");
			strSqlLibro.append(W83bImpugnacionesBD.f_reg_041);
			strSqlLibro.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
			strSqlLibro.append(",");
			strSqlLibro.append(W83bImpugnacionesBD.num_reg_041);
			strSqlLibro.append(" = ?");
			strSqlLibro.append(" WHERE ").append(W83bImpugnacionesBD.c_territ_041).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bImpugnacionesBD.ano_impug_041).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bImpugnacionesBD.n_impug_041).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bImpugnacionesBD.id_docu_041).append(" = ? ");
			
			
			
			for (int i=0;i<param.getListaDocs().size();i++)
			{
				W83bDocBeanImpug doc=(W83bDocBeanImpug)param.getListaDocs().get(i);
				//esto no va a ser asi cuando pongan la secuencia
				params.add(new Integer(idDocNext));//NOPMD
				params.add(doc.getNombre().toUpperCase());
				params.add(new Integer(doc.getTamanyo()));//NOPMD
				params.add(doc.getFileData());				
				params.add(param.getTerritorioImpugnacion().toUpperCase());
				//la fase siempre va a ser 5
				
				if (StringUtils.isNotEmpty(doc.getCodTramite()))
				{
					params.add(doc.getCodTramite().toUpperCase());

				}
				else
				{
					params.add("1");
				}
				params.add("5");
				params.add(param.getAnyoImpugnacion().toUpperCase());
				params.add(param.getNumImpugnacion());
				params.add (doc.getTipoDocumento().toUpperCase());

				if ("1".equals(param.getUsuarioBean().getRegManual()))
				{
					//Numero de registro
					if (StringUtils.isNotEmpty(doc.getNumeroRegistro()))
						params.add(doc.getNumeroRegistro());
					else
						params.add(W83bClsConstantes.NULL_STRING);
					
					
					//Fecha de registro
					if (StringUtils.isNotEmpty(doc.getFechaRegistro())){
						
						params.add(doc.getFechaRegistro());
					}else{
						params.add(W83bClsConstantes.NULL_DATE);
					}
					
					
				}
				else
				{
					params.add(W83bClsConstantes.NULL_STRING);
					params.add(W83bClsConstantes.NULL_DATE);
				}
				
				
				
				params.add(doc.getUsuario().toUpperCase());
				
				
				
				
				W83bDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),param.getUsuarioBean());
				
				params.clear();
				if ("0".equals(param.getUsuarioBean().getRegManual()))
				{
					//libro de registro
					 String observaciones="Documento de Impugnaciones Doc n: "+doc.getNombre()+" Impug n: "+param.getAnyoImpugnacion()+"/"+param.getNumImpugnacion()+"/"+param.getTerritorioImpugnacion();
					 String empresa="";
					 if(param.getTipoImpugnacion().equals("1"))
					 {
						 empresa=param.getDniImpug().toUpperCase();
					 }else if(param.getTipoImpugnacion().equals("2"))
					 {
						 empresa=(String)param.getCodsSindicatos().split("\\?")[0];
					 }
					 W83bUsuarioXLNetsBean usuarioLimitado = ((W83bIComunes)(W83bComunes.class.newInstance())).refrescarUsuarioDelegacion(param.getUsuarioBean());
					 
					 param.getUsuarioBean().setModelo(usuarioLimitado.getModelo());
					 param.getUsuarioBean().setModeloSal(usuarioLimitado.getModeloSal());
					try{ 		
						String [] resul=W83bLibroRegistro.getAltaRegistro(true,  param.getUsuarioBean().getModelo(),  "E", "E", empresa, param.getTerritorioImpugnacion(), "", observaciones, param.getUsuarioBean());
						
						//W83bLibroRegistroBean libroRegBean=W83bUtilidadesLibroRegistro.registrarLibroRegistro(param.getUsuarioBean());
						paramsLibro.add(resul[1]);
						paramsLibro.add(resul[0]);
						paramsLibro.add(param.getTerritorioImpugnacion());
						paramsLibro.add(new Integer(param.getAnyoImpugnacion()));//NOPMD
						paramsLibro.add(new Integer(param.getNumImpugnacion()));//NOPMD
						paramsLibro.add(new Integer(idDocNext));//NOPMD
						
						W83bDataBase.executeTableMovement(strSqlLibro.toString(), paramsLibro,param.getUsuarioBean());
					}catch(W83bLibroRegistroException e){
						resultado = "true";
					}
					
				}
				
				paramsLibro.clear();
				idDocNext++;
			}
			
		}
		return resultado;
	}

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#existeImpugnacion(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public boolean existeImpugnacion(W83bImpugnacionBean param)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		if(StringUtils.isEmpty(param.getNumImpugnacion()))
				{
					return false;
				}
		strSql.append("SELECT * FROM ").append(W83bImpugnacionesBD.tableImpugnaciones);
	
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.ano_impug).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.n_impug).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.c_territ).append(" = ? ");
		params.add(new Integer(param.getAnyoImpugnacion()));		
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(lista.size()>0){
			return true;
		}
		
		return false;
	}
	
	/**
	 * Existe laudo.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeLaudo(W83bImpugnacionBean param)
	throws Exception {
		if (StringUtils.isNotEmpty(param.getNumLaudo()) &&
				StringUtils.isNotEmpty(param.getAnyoLaudo()) &&
						StringUtils.isNotEmpty(param.getTerritorioLaudo()))
						{
			
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("SELECT * FROM ").append(W83bImpugnacionesBD.laudosImpugnacion);
			
			
			strSql.append(" WHERE ").append(W83bImpugnacionesBD.anyoImpugnacionLaudos).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionLaudos).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionLaudos).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.numLaudoLaudos).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.anyoLaudoLaudos).append(" = ? ");
			params.add(new Integer(param.getAnyoImpugnacion()));		
			params.add(new Integer(param.getNumImpugnacion()));
			params.add(param.getTerritorioImpugnacion());
			params.add(new Integer(param.getNumLaudo()));
			params.add(new Integer(param.getAnyoLaudo()));
			
			
			List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
			if(lista.size()>0){
				return true;
			}
			return false;
		
	}else{
		return false;
	}
		
		
		
	}
	/**
	 * Existe laudo.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean tieneLaudoDistinto(W83bImpugnacionBean param)
	throws Exception {
		if (StringUtils.isNotEmpty(param.getNumLaudo()) &&
				StringUtils.isNotEmpty(param.getAnyoLaudo()) &&
						StringUtils.isNotEmpty(param.getTerritorioLaudo()))
						{
			
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("SELECT * FROM ").append(W83bImpugnacionesBD.laudosImpugnacion);
			
			
			strSql.append(" WHERE ").append(W83bImpugnacionesBD.anyoImpugnacionLaudos).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionLaudos).append(" = ? ");
			strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionLaudos).append(" = ? ");
			strSql.append(" AND (").append(W83bImpugnacionesBD.numLaudoLaudos).append(" NOT IN  ? ");
			strSql.append(" OR ").append(W83bImpugnacionesBD.anyoLaudoLaudos).append(" NOT IN ? )");
			params.add(new Integer(param.getAnyoImpugnacion()));		
			params.add(new Integer(param.getNumImpugnacion()));
			params.add(param.getTerritorioImpugnacion());
			params.add(new Integer(param.getNumLaudo()));
			params.add(new Integer(param.getAnyoLaudo()));
			
			
			List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
			if(lista.size()>0){
				return true;
			}
			return false;
		
	}else{
		if(StringUtils.isEmpty(param.getNumLaudo()) &&
				StringUtils.isEmpty(param.getAnyoLaudo())){
			return true;
		}
		return false;
	}
		
		
		
	}
	/**
	 * Existe voz.
	 * 
	 * @param param the param
	 * @param tipoVoz the tipo voz
	 * @param voz the voz
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeVoz(W83bImpugnacionBean param, Integer tipoVoz, Integer voz)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT * FROM ").append( W83bImpugnacionesBD.vocesImpugnacion);
		
		
	
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.anyoImpugnacionVoces).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionVoces).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionVoces).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.numLaudoVoces).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.anyoLaudoVoces).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.codTipoVozVoces).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.codVozVoces).append(" = ? ");
		params.add(new Integer(param.getAnyoImpugnacion()));		
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		params.add(new Integer(param.getNumLaudo()));
		params.add(new Integer(param.getAnyoLaudo()));
		params.add(tipoVoz);
		params.add(voz);
		
		
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(lista.size()>0){
			return true;
		}
		
		return false;
	}
	
	/**
	 * Existe impugnante.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeImpugnante(W83bImpugnacionBean param)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT * FROM ").append( W83bImpugnacionesBD.impugnanteImpugnacion);
		
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.anyoImpugnacionesImpugnante).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionImpugnante).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.codTerritorioImpugnacionImpugnante).append(" = ? ");
		params.add(new Integer(param.getAnyoImpugnacion()));		
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getTerritorioImpugnacion());
		
		
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(lista.size()>0){
			return true;
		}
		
		return false;
	}

	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#borrarDocsImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	public void borrarDocsImpugnaciones(W83bImpugnacionBean param)
	throws Exception {
		if (param.getListaDocsBorrado()!=null && param.getListaDocsBorrado().size()>0)
		{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bImpugnacionesBD.impugnaciones_docsTable);
			strSql.append(" WHERE ");
			strSql.append(W83bImpugnacionesBD.id_docu_041).append(" = ?");
			
			for (int i=0;i< param.getListaDocsBorrado().size();i++)
			{
				String idDoc= (String)param.getListaDocsBorrado().get(i);
				params.add(idDoc);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.clear();
			}
		}
	}
public String existeLaudoImpugnacion(W83bListImpugnacionesBean param)
			throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesBD.resultadoLaudos);
		strSql.append(" FROM ").append(W83bImpugnacionesBD.laudosImpugnacion);
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.codTerritorioImpugnacionLaudos).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.anyoImpugnacionLaudos).append(" = ? ");
		strSql.append(" AND ").append(W83bImpugnacionesBD.numImpugnacionLaudos).append(" = ? ");
		params.add(param.getTerritorio());
		params.add(param.getAgnoImpugnacion());
		params.add(param.getNumImpugnacion());
		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bListImpugnacionesBean.class,param.getUsuarioBean(), null);
		if(lista.size()>0){
			return (String) (((W83bListImpugnacionesBean)lista.get(0)).getResultadoLaudo());
		}
		return null;
	}
	public String obtenerNumImpugnacion(HashMap mapaResultado) throws Exception {

		
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesVistaBD.NIMPUGNACION);
	
		strSql.append(" FROM ").append(W83bImpugnacionesVistaBD.impugnacionesView);
		
		strSql.append(" WHERE ").append(W83bImpugnacionesVistaBD.codTerritorioImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesVistaBD.anyoImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bImpugnacionesVistaBD.numImpugnacion).append(" = ?");
		
		params.add((String)mapaResultado.get("cterritorio"));
		params.add((String)mapaResultado.get("anio"));
		params.add(W83bUtilidades.rellenarCaracter((String)mapaResultado.get("num"),"0",W83bClsConstantes.SEIS,true));
			
		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bImpugnacionBean.class,null, null);
		if(lista.size()==0)
		{
			return W83bClsConstantes.CONSTANTE_NO;
		}
		return W83bClsConstantes.CONSTANTE_SI;
			
}


	
	   /**
	    * Actualiza la informacin de acuse de recibo de una comunicacin de un Impugnacion
	    * @param docBean W83bDocBean
	    * @throws Exception the exception
	    */
		public void  actualizarDatosAcuseComunicacion(W83bDocBean docBean) throws Exception {
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("UPDATE ");
			strSql.append(W83bMigracionBD.tabla41);
			strSql.append(" SET ");
			strSql.append(W83bMigracionBD.id_remesa_acuse_041);
			strSql.append(" = ?, ");
			params.add(docBean.getIdRemesaAcuse());
			strSql.append(W83bMigracionBD.cod_remesa_acuse_041);
			strSql.append(" = ?, ");
			params.add(docBean.getCodRemesaAcuse());
			strSql.append(W83bMigracionBD.id_coleccion_acuse_041);
			strSql.append(" = ?, ");
			params.add(docBean.getIdColeccionAcuse());
			strSql.append(W83bMigracionBD.cod_coleccion_acuse_041);
			strSql.append(" = ?, ");
			params.add(docBean.getCodColeccionAcuse());
			strSql.append(W83bMigracionBD.id_envio_acuse_041);
			strSql.append(" = ?, ");
			params.add(docBean.getIdEnvioAcuse());
			strSql.append(W83bMigracionBD.cod_envio_acuse_041);
			strSql.append(" = ? ");
			params.add(docBean.getCodEnvioAcuse());
			strSql.append(" WHERE ").append(W83bMigracionBD.codTerrit41).append(" = ? ");
			strSql.append(" AND ").append(W83bMigracionBD.anoImpug41).append(" = ? ");
			strSql.append(" AND ").append(W83bMigracionBD.numImpug41).append(" = ? ");
			params.add(docBean.getNumImpugnacionTerritorio());
			params.add(docBean.getNumImpugnacionAno());
			params.add(docBean.getNumImpugnacion());
			
			if(!StringUtils.isEmpty(docBean.getDestinatarioComunicLaudo())){
				strSql.append(" AND ").append(W83bMigracionBD.destinatario_com_laudo_041).append(" = ? ");
				params.add(docBean.getDestinatarioComunicLaudo());
			}
			
			strSql.append(" AND F_REG_041 IN (select max(F_REG_041) from W83B41T00 where ANO_IMPUG_041 = ? and N_IMPUG_041= ?  and C_TERRIT_041= ? " +
												"and c_tram_041 = ? and c_fase_041 = ? "); 
			params.add(docBean.getNumImpugnacionAno());
			params.add(docBean.getNumImpugnacion());
			params.add(docBean.getNumImpugnacionTerritorio());
			params.add(docBean.getCodTramite());
			params.add(docBean.getCodFase());
			if(!StringUtils.isEmpty(docBean.getDestinatarioComunicLaudo())){
				strSql.append(" AND ").append(W83bMigracionBD.destinatario_com_laudo_041).append(" = ? ");
				params.add(docBean.getDestinatarioComunicLaudo());
			}
			strSql.append(") ");


			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}
}

